function JsfiddleExporter(_html, _css, _js, _resources, _description, _pure) {
    this.html = '';
    this.css = '';
    this.js = '';
    this.resources = '';
    this.description = '';
    this.pure = 1;

    /**
     * Prepare the HTML part of the fiddle.
     */
    this.prepareHtml = function() {
        this.html = _html;
    };

    /**
     * Prepare the CSS part of the fiddle.
     */
    this.prepareCss = function() {
        this.css = _css;
    };

    /**
     * Prepare the JS part of the fiddle.
     */
    this.prepareJs = function() {
        this.js = _js;
    };

    /**
     * Prepare the Resources part of the fiddle.
     */
    this.prepareResources = function() {
        this.resources = _resources;
    };

    /**
     * Prepare the Resources part of the fiddle.
     */
    this.prepareDescription = function() {
        this.description = _description;
    };

    this.preparePure = function() {
        this.pure = _pure;
    }

    /**
     * Export the example's data to JsFiddle.
     */
    this.export = function(submit) {
        this.prepareHtml();
        this.prepareJs();
        this.prepareCss();
        this.prepareResources();
        this.prepareDescription();
        this.preparePure();

        // Currently not working - user needs to click 'Run' to make it work. Probably the external dependencies are loaded asynchrnonously.
        // this.prepareResources();

        if (submit) {
            this.submit();

            this.css = '';
            this.js = '';
            this.html = '';
            this.resources = '';
            this.description = '';
            this.pure = 1;
        }
    };

    /**
     * Create a temporary form and send data to JsFiddle.
     */
    this.submit = function() {
        var form = document.createElement('FORM'),
            url = "https://jsfiddle.net/api/post/library/pure/"
            html = [];

        // if (!this.pure) {
        //     url = 'https://jsfiddle.net/api/post/jquery/edge/';
        // }

        form.action = url;
        form.method = 'POST';
        form.target = '_blank';

        html.push('<input type="text" name="title" value="IB Sheet 8 Examples">');
        html.push('<textarea name="wrap">b</textarea>');

        if (this.resources && typeof this.resources === "string") {
            html.push('<textarea name="resources">' + this.resources.replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</textarea>');
        }

        if (this.html && typeof this.html === "string") {
            html.push('<textarea name="html">' + this.html.replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</textarea>');
        }

        if (this.js && typeof this.js === "string") {
            html.push('<textarea name="js">' + this.js.replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</textarea>');
        }

        if (this.css && typeof this.css === "string") {
            html.push('<textarea name="css">' + this.css.replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</textarea>');
        }

        if (this.description && typeof this.description === "string") {
            html.push('<textarea name="description">' + this.description.replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</textarea>');
        }

        form.innerHTML = html.join("");

        form.style.visibility = 'hidden';

        document.body.appendChild(form);
        form.submit();
        form.parentNode.removeChild(form);
    }
}